ScriptName RealFuel Extends ScriptObject

; You can use these however you like as long as credit is given.
; If you want to call them directly, simply run RealFuel.TheFunction() or Import RealFuel at the beginning of your script.

; This will prompt Real Fuel to perform all checks for travel and damage systems.
; It should generally be called after any alterations to SpaceshipGravJumpFuel's value.
Function Dashboard() Global
    RF:FuelHandlerQuest RF_FuelHandler = Game.GetFormFromFile(0x00081C, "rbt_RealFuel.esm") as RF:FuelHandlerQuest
    If RF_FuelHandler
        RF_FuelHandler.Dashboard()
    EndIf
EndFunction

; This will refuel the player's ship.
; Return Values:
; -1 = exception
;  0 = all fuel was used
;  other = more fuel was added than the ship could hold
float Function RefuelPlayerShip(float FuelToAdd, bool IsTotalRefill) Global
    float FuelDiff = -1
    RF:FuelHandlerQuest RF_FuelHandler = Game.GetFormFromFile(0x00081C, "rbt_RealFuel.esm") as RF:FuelHandlerQuest
    If RF_FuelHandler
        RF_FuelHandler.GetShip()
        float FuelDrawn = RF_FuelHandler.RealFuel(abComplete = IsTotalRefill, afAmount = FuelToAdd)
        FuelDiff = FuelToAdd - FuelDrawn
    EndIf
    Return FuelDiff
EndFunction

; This will drain fuel from the player's ship.
; Currently it will only drain either a set amount or the entire tank.
; There is a smart cap to avoid draining the value below 0, so don't worry about the drain amount.
; Return Values:
; -1 = exception
;  0 = script error
;  other = fuel in ship after drain procedure
float Function DrainPlayerShip(float FuelToDrain, bool IsTotalDrain) Global
    float FuelRemaining = -1
    RF:FuelHandlerQuest RF_FuelHandler = Game.GetFormFromFile(0x00081C, "rbt_RealFuel.esm") as RF:FuelHandlerQuest
    If RF_FuelHandler
        RF_FuelHandler.GetShip()
        RF_FuelHandler.ForceDrainFuel(abComplete = IsTotalDrain, afAmount = FuelToDrain)
        RF_FuelHandler.Dashboard()
        FuelRemaining = RF_FuelHandler.CheckFuelAmount()
    EndIf
    Return FuelRemaining
EndFunction

; This returns a float value (0.0 > 1.0) of the fuel in the player ship's tanks.
; If AsPercent = true, it will return 0 - 100.
; -1 return value indicates the function failed to run.
float Function GetTankLevels(bool abAsPercent) Global
    float fuel = 1.0
    RF:FuelHandlerQuest RF_FuelHandler = Game.GetFormFromFile(0x00081C, "rbt_RealFuel.esm") as RF:FuelHandlerQuest
    If RF_FuelHandler
        RF_FuelHandler.GetShip()
        If !abAsPercent
            fuel = RF_FuelHandler.GetFuelLevel()
        Else
            fuel = RF_FuelHandler.GetFuelLevelInt() as float
        EndIF
    Else
        Fuel = -1
    EndIF
    Return Fuel
EndFunction

; This will prompt the main system to re-assign its used ship to SQ_PlayerShip.PlayerShip
; You can either call this for convenience or if you changed the ship forcibly somehow
; returns true if assignment was successful
bool Function ResetShipRF() Global
    bool IsShipOK = false
    RF:FuelHandlerQuest RF_FuelHandler = Game.GetFormFromFile(0x00081C, "rbt_RealFuel.esm") as RF:FuelHandlerQuest
    SQ_PlayerShipScript SQ_PlayerShip = Game.GetForm(0x000174a2) as SQ_PlayerShipScript
    If RF_FuelHandler
        SpaceshipReference MyShipRF = RF_FuelHandler.GetShip()
        SpaceshipReference MyShipSQ = SQ_PlayerShip.PlayerShip.GetShipRef()
        If MyShipRF == MyShipSQ
            IsShipOK = True
        EndIF
    EndIF
    Return IsShipOK
EndFunction